<?php
/**
 * WebEngine
 * http://muengine.net/
 * 
 * @version 1.0.9.7
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2017 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

if(!isLoggedIn()) redirect(1,'login');
if(!check_value($_GET['id'])) redirect(1, 'tickets/list');

echo '<div class="page-title"><span>'.lang('plugin_ticketsupport_3', true).'</span></div>';

if(check_value($_POST['submit'])) {
	try {
		
		$ticketSystem = new ticketSystem();
		$ticketSystem->setId($_GET['id']);
		$ticketSystem->setUsername($_SESSION['username']);
		$ticketSystem->setMessage($_POST['reply_message']);
		$ticketSystem->reply();
		
		message('success', lang('plugin_ticketsupport_16', true));
		
	} catch(Exception $ex) {
		message('error', $ex->getMessage());
	}
}

try {
	
	$ticketSystem = new ticketSystem();
	$ticketSystem->setId($_GET['id']);
	
	$ticketData = $ticketSystem->getTicketData();
	if(!is_array($ticketData)) throw new Exception(lang('plugin_ticketsupport_17', true));
	if($ticketData['ticket_author'] != $_SESSION['username']) throw new Exception(lang('plugin_ticketsupport_18', true));
	
	$ticketReplies = $ticketSystem->getTicketReplies();
	if(!is_array($ticketReplies)) throw new Exception(lang('plugin_ticketsupport_19', true));
	
	echo '<h2>'.$ticketData['ticket_subject'].'</h2>';
	foreach($ticketReplies as $reply) {
		echo '<div class="panel panel-general">';
			echo '<div class="panel-body">';
				echo '<div class="row" style="border-bottom: 1px solid #1f1f1f;padding: 0px 15px;">';
					echo '<div class="col-xs-6" style="padding: 10px 0px;font-weight: bold;">';
						echo $reply['reply_author'];
					echo '</div>';
					echo '<div class="col-xs-6 text-right" style="padding: 10px 0px;font-style: italic;color: #777;font-size:11px;">';
						echo date("Y-m-d H:i",$reply['reply_date']);
					echo '</div>';
				echo '</div>';
				echo '<div class="row">';
					echo '<div class="col-xs-12" style="padding: 15px;">';
						echo nl2br(htmlspecialchars($reply['reply_content']));
					echo '</div>';
				echo '</div>';
			echo '</div>';
		echo '</div>';
	}
	
	if($ticketData['ticket_status'] == 0) {
		echo '<div class="panel panel-general">';
			echo '<div class="panel-body">';
				echo '<form action="" method="post">';
					echo '<div class="form-group">';
						echo '<label for="contactInput2">'.lang('plugin_ticketsupport_5', true).'</label>';
						echo '<textarea class="form-control" id="contactInput2" style="height:150px;" name="reply_message"></textarea>';
					echo '</div>';
					echo '<button type="submit" name="submit" value="submit" class="btn btn-primary">'.lang('plugin_ticketsupport_14', true).'</button>';
				echo '</form>';
			echo '</div>';
		echo '</div>';
	}
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}